#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//vueltas n2Mod01.fsh   by   jorge2017a2
//https://www.shadertoy.com/view/7d2BzV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a2----7-mar-2022
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2
// start Common //
//-------common
#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)

struct Ray
{   vec3 ro; // origin
    vec3 rd; // direction
};

///Gracias a SHane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    return mat3(tx*tx, ty*ty, tz*tz)*n; 
}

// end Common  //


vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }

float sdSphere( vec3 p, float s )
   { return length(p)-s;}

float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}
float unionSDF(float distA, float distB)
	{ return min(distA, distB);}
float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
///------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{   float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}

float tau = atan(1.0) * 8.0;
vec3 opAngRep( vec3 p, float a )
{   vec2 polar = vec2(atan(p.y, p.x), length(p.xy));
    polar.x = mod(polar.x + a / 2.0, a) - a / 2.0;
    return vec3(polar.y * vec2(cos(polar.x),sin(polar.x)), p.z);
}

vec3 opAngRepFull( vec3 p, float numItem )
{   return opAngRep(p, tau / numItem); }

vec2 Edificio01(vec3 p, vec2 pdist)
{   vec2 res=pdist; 
    float numItem=6.0;
    vec3 pnew= opAngRepFull( p.xzy,numItem );
    vec3 pnew1=pnew-vec3(15.0,0.0,0.0);
    vec3 pnew2=pnew-vec3(40.0,15.0,0.0);
    vec3 pnew3=pnew-vec3(75.0,5.0,0.0);
    vec3 pnew4=pnew-vec3(50.0,10.0,25.0);
    float d1= sdCylinderXY( pnew1-vec3(3.0,0.0,0.0), vec2(2.0,6.0) );
    float d2= sdCylinderXY( rotate_x(pnew2 , radians(10.0)) , vec2(1.0,8.0) );
    float d3= sdCylinderXY( rotate_x(pnew3 , radians(-20.0)) , vec2(6.0,15.0) );
    float d4= sdBox(rotate_y(rotate_x( pnew1-vec3(15.0,0.0,0.0),radians(-20.0)),radians(-20.)), vec3(2.0,2,14.0) );
    float d5= sdSphere(pnew4,5.0 );
    res =opU2(res, vec2(d1,100.0));
    res =opU2(res, vec2(d2,101.0));
    res =opU2(res, vec2(d3,100.0));
    res =opU2(res, vec2(d4,101.0));
    res =opU2(res, vec2(d5,100.0));
    return res;
}

vec2 GetDist(vec3 p  ) 
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
	float planeDist1 = p.y-1.0;  //piso inf
    res =opU2(res, vec2(planeDist1+sin(p.x*0.015+(p.z*0.25+p.y*cos(p.x*0.5))),100.0));
    p.y=p.y-5.0;
    vec2 ed1= Edificio01(p, res);
    res =opU2(res, ed1);
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

vec2 RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   float t = 0.1;
    float tmax = 40.0;
    vec3 p;
    vec2 hit, object=vec2(0.1,0.0);
    
   for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*object.x;
        hit = GetDist(p);
        object.x += hit.x;
        object.y = hit.y;
        if (abs(hit.x) < EPSILON || object.x > MAX_DIST) break;
    }
    return object;
}


float getSoftShadow(vec3 p, vec3 lightPos) {
    float res = 1.0;
    float dist = 0.01;
    float lightSize = 0.03;
    for (int i = 0; i < MAX_STEPS; i++) {
        float hit = GetDist(p + lightPos * dist).x;
        res = min(res, hit / (dist * lightSize));
        dist += hit;
        if (hit < 0.0001 || dist > 60.0) break;
    }
    return clamp(res, 0.0, 1.0);
}

float occlusion(vec3 pos, vec3 nor)
{   float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {
        float hr = 0.01 + float(i) * 0.5 / 4.0;
        float dd = GetDist(nor * hr + pos).x;
        occ += (hr - dd)*sca;
        sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 color, float t) 
{   vec3 lightPos=lp;
    vec3 hit = ro + rd * t;
    vec3 norm = GetNormal(hit);
    vec3 light = lightPos - hit;
    float lightDist = max(length(light), .001);
    float atten = 1. / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    light /= lightDist;
    
    vec3 R = reflect(-light, norm);
    vec3 V = -rd;
    
    float shadow = getSoftShadow(hit, normalize(lightPos)); // shadows 
    float occ = occlusion(hit, norm); //occ
    vec3 ambient= 0.5*color*clamp(0.5 + 0.5*norm.y, 0.0, 1.0);
    vec3 fresnel =  color *  pow(clamp(1.0 + dot(rd, norm), 0.0, 1.0), 2.0);;
    
    float dif = clamp(dot(norm, light), 0.0, 1.0);
    dif = pow(dif, 4.) * 2.;
    vec3 diffuse =  color * dif;
    
    float specular = pow(max(dot(R, V), 0.), 8.);
    vec3 back = 0.5 * color * clamp(dot(norm, -light), 0.0, 1.0);
       vec3 colOut = occ*color*(ambient+diffuse*shadow+.35 +back) + vec3(.7,.9,1)*specular*specular;
    return colOut;
}

vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    { vec3 col=tex3D(texture0, p/32., nor); return col*2.0; }
	if (i==101 ) { return tex3D(texture1, p/32., nor); }
}

vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos, float tdist)
{  float intensity=1.0;
     vec3 result;
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj, tdist);
    return result;
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}


vec3 GetMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color)
{  	vec3 colobj; 
   if (id_color==100)
       { return getColorTextura( p, n,100); }
   if (id_color==101)
       { return getColorTextura( p, n,101); }
}

vec3 linear2srgb(vec3 c) 
{ return mix(12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055, step(vec3(0.0031308), c)); }

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{ return vec3(1.0) - exp(-hdrColor * exposure); }

vec3 ACESFilm(vec3 x)
{   float a,b,c,d,e;
    a = 2.51; b = 0.03; c = 2.43; 
    d = 0.59; e = 0.14;
    return (x*(a*x+b))/(x*(c*x+d)+e);
}

vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
  vec3 p;
     vec2 hit=RayMarch(ro,rd, MAX_STEPS);
      if(hit.x<MAX_DIST) 
       {   p = (ro + rd * hit.x );  
        vec3 nor=GetNormal(p);
        vec3 colobj;
        colobj=GetMaterial( p, nor, ro, rd,  int(hit.y));
        vec3 result;
         result=  Getluz( p,ro,rd, nor, colobj ,light_pos1,hit.x)*light_color1;
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2,hit.x)*light_color2;
        col= result/2.0;
        col= (ACESFilm(col)+linear2srgb(col)+col+ exposureToneMapping(3.0, col))/4.0 ;
    }
    ///shane
    col = mix(col, render_sky_color(rd), smoothstep(.25, .99, hit.x/MAX_DIST));
   return col;
}

Ray RotarEnCirculo(vec3 ro,vec3 rd)
{
   float r=37.0;
   float veltime=20.0;  
    float tt = radians( -iTime*veltime);
    vec3  pos=vec3(0.0,-1.5,25.0);
    vec3 rotation1 = pos+vec3(r*sin(tt), 0.0, r*cos(tt));
    ro +=rotation1;   
    rd=rotate_y( vec3(-rd.x,rd.y,-rd.z), tt);
    return  Ray(ro,rd);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
 	light_pos1= vec3(-10.0, 120.0, -25.); light_color1=vec3( 1.0,1.0,1.0 );
 	light_pos2= vec3(10.0, 20.0, -25.0 ); light_color2 =vec3( 1.0,1.0,1.0 ); 
   vec3 ro=vec3(0.0,7.0,-25.0);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));   
    rd= rotate_y(rd, radians(60.0));
   Ray ray= RotarEnCirculo(ro,rd);
    ro=ray.ro;
    rd=ray.rd;
    vec3 col= Render( ro,  rd);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

